import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';

export interface FoodItem {
  name: string;
  price: number;
  calories: number;
}

@Injectable({ providedIn: 'root' })
export class FoodService {
  constructor(private http: HttpClient) {}

  getBreakfast(): Observable<FoodItem[]> {
    return this.http.get<FoodItem[]>('assets/breakfast.json');
  }

  getLunch(): Observable<FoodItem[]> {
    return this.http.get<FoodItem[]>('assets/lunch.json');
  }

  getDinner(): Observable<FoodItem[]> {
    return this.http.get<FoodItem[]>('assets/dinner.json');
  }
}

